// testrotView.cpp : implementation of the CTestrotView class
// written by stoyan demirev
// stoyan@mailcity.com
// stoyanbd@hotmail.com
// december99
#include "stdafx.h"
#include "testrot.h"

#include "testrotDoc.h"
#include "testrotView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTestrotView

IMPLEMENT_DYNCREATE(CTestrotView, CView)

BEGIN_MESSAGE_MAP(CTestrotView, CView)
	//{{AFX_MSG_MAP(CTestrotView)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_CANCELMODE()
	ON_WM_CAPTURECHANGED()
	ON_WM_DESTROY()
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestrotView construction/destruction

#include "math.h"
#include "conio.h"
#include "MainFrm.h"

int x = 10, y = 0, z = -100; 
static char trig = 0;
 
UINT ThreadFunc(LPVOID param);

CTestrotView::CTestrotView()
{

}

CTestrotView::~CTestrotView()
{
}

BOOL CTestrotView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CTestrotView drawing

void CTestrotView::OnDraw(CDC * pDC)
{

}

/////////////////////////////////////////////////////////////////////////////
// CTestrotView printing

BOOL CTestrotView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CTestrotView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CTestrotView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CTestrotView diagnostics

#ifdef _DEBUG
void CTestrotView::AssertValid() const
{
	CView::AssertValid();
}

void CTestrotView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CTestrotDoc* CTestrotView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTestrotDoc)));
	return (CTestrotDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
inline void swap(int &a, int &b)
{
	int temp = a;
	a = b;
	b = temp;
}

void DrawLine(HDC hdc, int x1, int y1, int x2, int y2, int col)
{
	int xadd1 = 1, yadd1 = 1, xadd2 = 1, yadd2 = 1;
	int p, q, s, x = x1, y = y1;

	p = y1 - y2; q = x1 - x2;

	if (p > 0) {yadd1 = yadd2 = -1;} else if (!p) yadd1 =yadd2 =0;
	if (q > 0) {xadd1 = xadd2 = -1;} else if (!q) xadd1 =xadd2 =0;

	p = abs(p);
	q = abs(q);
	if (q > p) 
		yadd2 = 0;
	else 
	{
		xadd2 = 0;
		swap(p, q);
	}

	s = p - q / 2;
	for (int i = 0; i < q + 1; i++)
	{
		SetPixel(hdc, x, y, col);
		if (s > 0) 
		{
			x += xadd1; 
			y += yadd1;
			s += p - q;
		}
		else	
		{
			x += xadd2;
			y += yadd2;
			s += p;
		}
	}
}

#define SWAP(x, y) {x = x + y; y = x- y; x = x- y;}

void PoliFiller(POINT p[5], HDC hdc, int Height, int color)//5 points - to connect the first with the last
{
	int * left  = new int [Height];
	int * right = new int [Height];

	for (int j = 0; j < Height; j++) left[j] = 1000;
	memset(right, -1, Height);

	for (int i = 0; i < 4; i++)
	{
		POINT p1 = p[i];
		POINT p2 = p[i + 1];

		if (p1.y > p2.y)
		{
			SWAP(p1.x, p2.x);
			SWAP(p1.y, p2.y);
		}

		float dx = float(p2.x - p1.x) / float(p2.y - p1.y);
		float x = p1.x;

		for (int y = p1.y; y < p2.y; y++)
		{
			if (x < left[y]) 
				left[y]  = x;
			if (x > right[y]) 
				right[y] = x;

			x += dx;
		}

	}


	for (i = 0; i < Height; i++)
		if (left[i] < 1000 && right[i] > -1)
		{
			DrawLine(hdc, left[i], i, right[i], i, color);
		}


	delete left;
	delete right;
}

class Point3d
{
public :
	Point3d() {};
	Point3d(double tx, double ty, double tz) {x = tx; y = ty; z = tz;}
	double x, y, z;
	int sx, sy;
	Point3d operator=(Point3d &p);
 	void Project(int CenterX, int CenterY) {sx = CenterX + 256 * x / (256 - z);
									  sy = CenterY + 256 * y / (256 - z);}

};

Point3d Point3d::operator=(Point3d &p)
{
	return Point3d(p.x, p.y, p.z);
}

class Face3d
{
public :
	Face3d() {};
	Face3d(Point3d * tp1, Point3d * tp2, Point3d * tp3, Point3d * tp4) {p1 =tp1; p2 =tp2; p3 = tp3; p4 = tp4;}
	Point3d * p1, * p2, * p3, * p4;
	Point3d normal;
	Point3d midpoint;
	Face3d operator=(Face3d &f);
	void Display(HDC hdc, int color);//color will be sacked when i get double buffering
	void DisplayColored(HDC hdc, int color, int height);
};

void Face3d::Display(HDC hdc, int color)
{

/*	DisplayColored(hdc, color, 1000); 
	return;
*/	Point3d * tp1 = new Point3d(), * tp2 = new Point3d();

	tp1->x = p2->x - p1->x;
	tp1->y = p2->y - p1->y;
	tp1->z = p2->z - p1->z;
	tp2->x = p3->x - p1->x;
	tp2->y = p3->y - p1->y;
	tp2->z = p3->z - p1->z;

	normal.x = tp1->y * tp2->z - tp2->y * tp1->z;
	normal.y = tp1->z * tp2->x - tp2->z * tp1->x;
	normal.z = tp1->x * tp2->y - tp2->x * tp1->y;
	
	double length = sqrt(normal.x * normal.x +
						 normal.y * normal.y +
						 normal.z * normal.z);

	normal.x =  normal.x / length;
	normal.y =  normal.y / length;
	normal.z =  normal.z / length;

	delete tp1;
    delete tp2;

    float D = normal.x * p2->x + normal.y * p2->y + normal.z * p2->z;

	if (normal.z * 256 - D < 0) return;//current view vector is (0, 0, 255);

	DrawLine(hdc, p1->sx, p1->sy, p2->sx, p2->sy, color);
	DrawLine(hdc, p2->sx, p2->sy, p3->sx, p3->sy, color);
	DrawLine(hdc, p3->sx, p3->sy, p4->sx, p4->sy, color);
	DrawLine(hdc, p4->sx, p4->sy, p1->sx, p1->sy, color);

	//Sleep(400);
}

void Face3d::DisplayColored(HDC hdc, int color, int height)
{
	POINT p[5] = {{p1->sx, p1->sy}, {p2->sx, p2->sy}, {p3->sx, p3->sy}, {p4->sx, p4->sy}, {p1->sx, p1->sy}};
	PoliFiller(p, hdc, height, color);
}

Face3d Face3d::operator=(Face3d &f)
{
	return Face3d(f.p1, f.p2, f.p3, f.p4);
}

class Cube
{
public :
	Cube() {};
	PointsToFaces();
	SortFaces();
	Point3d points[8];
	Point3d transformed[8];
	Face3d faces[6];
	Rotate(double ax, double ay, double az);
	Project(int CenterX, int CenterY);
	Display(HDC hdc, int color);
};

Cube::PointsToFaces() //in clockwise order
{
	Point3d * tp1 = new Point3d(), * tp2 = new Point3d();
	double length;

	//back
	faces[0].p1 = &transformed[0];
	faces[0].p2 = &transformed[3];
	faces[0].p3 = &transformed[2];
	faces[0].p4 = &transformed[1];
	faces[0].midpoint = Point3d((faces[0].p1->x + faces[0].p2->x + faces[0].p3->x + faces[0].p4->x) / 4,
								(faces[0].p1->y + faces[0].p2->y + faces[0].p3->y + faces[0].p4->y) / 4,
								(faces[0].p1->z + faces[0].p2->z + faces[0].p3->z + faces[0].p4->z) / 4);
/*
//calc the normal

	tp1->x = faces[0].p2->x - faces[0].p1->x;
	tp1->y = faces[0].p2->y - faces[0].p1->y;
	tp1->z = faces[0].p2->z - faces[0].p1->z;
	tp2->x = faces[0].p2->x - faces[0].p3->x;
	tp2->y = faces[0].p2->y - faces[0].p3->y;
	tp2->z = faces[0].p2->z - faces[0].p3->z;
	
	faces[0].normal.x = tp1->y * tp2->z - tp2->y * tp1->z;
	faces[0].normal.y = tp1->z * tp2->x - tp2->z * tp1->x;
	faces[0].normal.z = tp1->x * tp2->y - tp2->x * tp1->y;
	
	length = sqrt(faces[0].normal.x * faces[0].normal.x +
				  faces[0].normal.y * faces[0].normal.y +
				  faces[0].normal.z * faces[0].normal.z);

	faces[0].normal.x = faces[0].normal.x / length;
	faces[0].normal.y = faces[0].normal.y / length;
	faces[0].normal.z = faces[0].normal.z / length;
*/
	//front
	faces[1].p1 = &transformed[4];
	faces[1].p2 = &transformed[5];
	faces[1].p3 = &transformed[6];
	faces[1].p4 = &transformed[7];
	faces[1].midpoint = Point3d((faces[1].p1->x + faces[1].p2->x + faces[1].p3->x + faces[1].p4->x) / 4,
								(faces[1].p1->y + faces[1].p2->y + faces[1].p3->y + faces[1].p4->y) / 4,
								(faces[1].p1->z + faces[1].p2->z + faces[1].p3->z + faces[1].p4->z) / 4);

/*
//calc the normal

	tp1->x = faces[1].p2->x - faces[1].p1->x;
	tp1->y = faces[1].p2->y - faces[1].p1->y;
	tp1->z = faces[1].p2->z - faces[1].p1->z;
	tp2->x = faces[1].p2->x - faces[1].p3->x;
	tp2->y = faces[1].p2->y - faces[1].p3->y;
	tp2->z = faces[1].p2->z - faces[1].p3->z;
	
	faces[1].normal.x = tp1->y * tp2->z - tp2->y * tp1->z;
	faces[1].normal.y = tp1->z * tp2->x - tp2->z * tp1->x;
	faces[1].normal.z = tp1->x * tp2->y - tp2->x * tp1->y;

	length = sqrt(faces[1].normal.x * faces[1].normal.x +
				  faces[1].normal.y * faces[1].normal.y +
				  faces[1].normal.z * faces[1].normal.z);

	faces[1].normal.x = faces[1].normal.x / length;
	faces[1].normal.y = faces[1].normal.y / length;
	faces[1].normal.z = faces[1].normal.z / length;
*/
	//right
	faces[2].p1 = &transformed[0];
	faces[2].p2 = &transformed[4];
	faces[2].p3 = &transformed[7];
	faces[2].p4 = &transformed[3];
	faces[2].midpoint = Point3d((faces[2].p1->x + faces[2].p2->x + faces[2].p3->x + faces[2].p4->x) / 4,
								(faces[2].p1->y + faces[2].p2->y + faces[2].p3->y + faces[2].p4->y) / 4,
								(faces[2].p1->z + faces[2].p2->z + faces[2].p3->z + faces[2].p4->z) / 4);

/*
//calc the normal

	tp1->x = faces[2].p2->x - faces[2].p1->x;
	tp1->y = faces[2].p2->y - faces[2].p1->y;
	tp1->z = faces[2].p2->z - faces[2].p1->z;
	tp2->x = faces[2].p2->x - faces[2].p3->x;
	tp2->y = faces[2].p2->y - faces[2].p3->y;
	tp2->z = faces[2].p2->z - faces[2].p3->z;
	
	faces[2].normal.x = tp1->y * tp2->z - tp2->y * tp1->z;
	faces[2].normal.y = tp1->z * tp2->x - tp2->z * tp1->x;
	faces[2].normal.z = tp1->x * tp2->y - tp2->x * tp1->y;

	length = sqrt(faces[2].normal.x * faces[2].normal.x +
				  faces[2].normal.y * faces[2].normal.y +
				  faces[2].normal.z * faces[2].normal.z);

	faces[2].normal.x = faces[2].normal.x / length;
	faces[2].normal.y = faces[2].normal.y / length;
	faces[2].normal.z = faces[2].normal.z / length;
*/
	//left
	faces[3].p1 = &transformed[5];
	faces[3].p2 = &transformed[1];
	faces[3].p3 = &transformed[2];
	faces[3].p4 = &transformed[6];
	faces[3].midpoint = Point3d((faces[3].p1->x + faces[3].p2->x + faces[3].p3->x + faces[3].p4->x) / 4,
								(faces[3].p1->y + faces[3].p2->y + faces[3].p3->y + faces[3].p4->y) / 4,
								(faces[3].p1->z + faces[3].p2->z + faces[3].p3->z + faces[3].p4->z) / 4);

/*
//calc the normal

	tp1->x = faces[3].p2->x - faces[3].p1->x;
	tp1->y = faces[3].p2->y - faces[3].p1->y;
	tp1->z = faces[3].p2->z - faces[3].p1->z;
	tp2->x = faces[3].p2->x - faces[3].p3->x;
	tp2->y = faces[3].p2->y - faces[3].p3->y;
	tp2->z = faces[3].p2->z - faces[3].p3->z;
	
	faces[3].normal.x = tp1->y * tp2->z - tp2->y * tp1->z;
	faces[3].normal.y = tp1->z * tp2->x - tp2->z * tp1->x;
	faces[3].normal.z = tp1->x * tp2->y - tp2->x * tp1->y;

	length = sqrt(faces[3].normal.x * faces[3].normal.x +
				  faces[3].normal.y * faces[3].normal.y +
				  faces[3].normal.z * faces[3].normal.z);

	faces[3].normal.x = faces[3].normal.x / length;
	faces[3].normal.y = faces[3].normal.y / length;
	faces[3].normal.z = faces[3].normal.z / length;
*/
	//bottom
	faces[4].p1 = &transformed[7];
	faces[4].p2 = &transformed[6];
	faces[4].p3 = &transformed[2];
	faces[4].p4 = &transformed[3];
	faces[4].midpoint = Point3d((faces[4].p1->x + faces[4].p2->x + faces[4].p3->x + faces[4].p4->x) / 4,
								(faces[4].p1->y + faces[4].p2->y + faces[4].p3->y + faces[4].p4->y) / 4,
								(faces[4].p1->z + faces[4].p2->z + faces[4].p3->z + faces[4].p4->z) / 4);

/*
//calc the normal

	tp1->x = faces[4].p2->x - faces[4].p1->x;
	tp1->y = faces[4].p2->y - faces[4].p1->y;
	tp1->z = faces[4].p2->z - faces[4].p1->z;
	tp2->x = faces[4].p2->x - faces[4].p3->x;
	tp2->y = faces[4].p2->y - faces[4].p3->y;
	tp2->z = faces[4].p2->z - faces[4].p3->z;
	
	faces[4].normal.x = tp1->y * tp2->z - tp2->y * tp1->z;
	faces[4].normal.y = tp1->z * tp2->x - tp2->z * tp1->x;
	faces[4].normal.z = tp1->x * tp2->y - tp2->x * tp1->y;

	length = sqrt(faces[4].normal.x * faces[4].normal.x +
				  faces[4].normal.y * faces[4].normal.y +
				  faces[4].normal.z * faces[4].normal.z);

	faces[4].normal.x = faces[4].normal.x / length;
	faces[4].normal.y = faces[4].normal.y / length;
	faces[4].normal.z = faces[4].normal.z / length;
*/
	//top
	faces[5].p1 = &transformed[0];
	faces[5].p2 = &transformed[1];
	faces[5].p3 = &transformed[5];
	faces[5].p4 = &transformed[4];
	faces[5].midpoint = Point3d((faces[5].p1->x + faces[5].p2->x + faces[5].p3->x + faces[5].p4->x) / 4,
								(faces[5].p1->y + faces[5].p2->y + faces[5].p3->y + faces[5].p4->y) / 4,
								(faces[5].p1->z + faces[5].p2->z + faces[5].p3->z + faces[5].p4->z) / 4);

/*
//calc the normal

	tp1->x = faces[5].p2->x - faces[5].p1->x;
	tp1->y = faces[5].p2->y - faces[5].p1->y;
	tp1->z = faces[5].p2->z - faces[5].p1->z;
	tp2->x = faces[5].p2->x - faces[5].p3->x;
	tp2->y = faces[5].p2->y - faces[5].p3->y;
	tp2->z = faces[5].p2->z - faces[5].p3->z;
	
	faces[5].normal.x = tp1->y * tp2->z - tp2->y * tp1->z;
	faces[5].normal.y = tp1->z * tp2->x - tp2->z * tp1->x;
	faces[5].normal.z = tp1->x * tp2->y - tp2->x * tp1->y;

	length = sqrt(faces[5].normal.x * faces[5].normal.x +
				  faces[5].normal.y * faces[5].normal.y +
				  faces[5].normal.z * faces[5].normal.z);

	faces[5].normal.x = faces[5].normal.x / length;
	faces[5].normal.y = faces[5].normal.y / length;
	faces[5].normal.z = faces[5].normal.z / length;
*/
}

Cube::SortFaces()
{
	Face3d * f = new Face3d();

	for (int i = 0; i < 5; i++)
		for (int j = i + 1; j < 6; j++)
			if (faces[i].midpoint.z > faces[j].midpoint.z)
			{
				f = &faces[i];
				faces[i] = faces[j];
				faces[j] = * f;
			}
}

Cube::Rotate(double ax, double ay, double az)
{
	Point3d tempBuffer1, tempBuffer2;

	for (int i = 0; i < 8; i++)
	{
		//rotate around x axis
		tempBuffer1.x = points[i].x;
		tempBuffer1.y = points[i].y * cos(ax) + points[i].z * sin(ax);
		tempBuffer1.z = - points[i].y * sin(ax) + points[i].z * cos(ax);
		
		//rotate around y axis
		tempBuffer2.x = tempBuffer1.x * cos(ay) - tempBuffer1.z * sin(ay);
		tempBuffer2.y = tempBuffer1.y;
		tempBuffer2.z = tempBuffer1.x * sin(ay) + tempBuffer1.z * cos(ay);

		//rotate around z axis
		transformed[i].x = tempBuffer2.x * cos(az) + tempBuffer2.y * sin(az);
		transformed[i].y =  - tempBuffer2.x * sin(az) + tempBuffer2.y * cos(az);
		transformed[i].z = tempBuffer2.z;
	}
}

Cube::Project(int CenterX, int CenterY)
{
	for (int i = 0; i < 8; i++)
	{
		transformed[i].sx = CenterX + 256 * transformed[i].x / (256 - transformed[i].z);
		transformed[i].sy = CenterY + 256 * transformed[i].y / (256 - transformed[i].z);
	}
}

Cube::Display(HDC hdc, int color)
{
	for (int i = 0; i < 6; i++)
	{
		faces[i].Display(hdc, color);
	}	
}

UINT ThreadFunc(LPVOID param)
{

/*	CDC * pDC = (CDC *)param; it somehow appears that the thread
	doesnt get the correct DC this way, so its grasped though GetDC() 
	see further below */
 

	double az = 5 * 3.1415 / 180;
	double ax = 5 * 3.1415 / 180;
	double ay = 5 * 3.1415 / 180;

	CRect rect;
	AfxGetThread()->GetMainWnd()->GetWindowRect(rect);
	AfxGetThread()->m_bAutoDelete = TRUE;

	CDC * pDC = AfxGetThread()->GetMainWnd()->GetDC();

	Cube cube;	

	int scrHalfWidth = rect.Width() >> 1, scrHalfHeight = rect.Height() >> 1;
/*	
	Point3d * ox = new Point3d(100, 0, 0), * oy = new Point3d(0, 100, 0),
			* oz = new Point3d(0, 0, 100), * o = new Point3d(0, 0, 0);

	ox->Project(scrHalfWidth, scrHalfHeight);
	oy->Project(scrHalfWidth, scrHalfHeight);
	oz->Project(scrHalfWidth, scrHalfHeight);
	o->Project(scrHalfWidth, scrHalfHeight);
*/
	cube.points[0].x = 40; cube.points[0].y = 40; cube.points[0].z = -40;
	cube.points[1].x = -40; cube.points[1].y = 40; cube.points[1].z = -40;
	cube.points[2].x = -40; cube.points[2].y = -40; cube.points[2].z = -40;
	cube.points[3].x = 40; cube.points[3].y = -40; cube.points[3].z = -40;
	cube.points[4].x = 40; cube.points[4].y = 40; cube.points[4].z = 40;
	cube.points[5].x = -40; cube.points[5].y = 40; cube.points[5].z = 40;
	cube.points[6].x = -40; cube.points[6].y = -40; cube.points[6].z = 40;
	cube.points[7].x = 40; cube.points[7].y = -40; cube.points[7].z = 40;

	cube.transformed[0].x = 40; cube.transformed[0].y = 40; cube.transformed[0].z = -40;
	cube.transformed[1].x = -40; cube.transformed[1].y = 40; cube.transformed[1].z = -40;
	cube.transformed[2].x = -40; cube.transformed[2].y = -40; cube.transformed[2].z = -40;
	cube.transformed[3].x = 40; cube.transformed[3].y = -40; cube.transformed[3].z = -40;
	cube.transformed[4].x = 40; cube.transformed[4].y = 40; cube.transformed[4].z = 40;
	cube.transformed[5].x = -40; cube.transformed[5].y = 40; cube.transformed[5].z = 40;
	cube.transformed[6].x = -40; cube.transformed[6].y = -40; cube.transformed[6].z = 40;
	cube.transformed[7].x = 40; cube.transformed[7].y = -40; cube.transformed[7].z = 40;

	cube.PointsToFaces();

	while (trig) {

//	cube.SortFaces();

	cube.Project(scrHalfWidth, scrHalfHeight);
	cube.Display(pDC->m_hDC, 0x000000ff);	

/* coordinate axes
	DrawLine(pDC->m_hDC, o->sx, o->sy, ox->sx, ox->sy, 0x000000ff);
	DrawLine(pDC->m_hDC, o->sx, o->sy, oy->sx, oy->sy, 0x000000ff);
	DrawLine(pDC->m_hDC, o->sx, o->sy, oz->sx, oz->sy, 0x000000ff);
*/
	Sleep(50);

	az += 5 * 3.1415 / 180;
	ax += 3 * 3.1415 / 180;
	ay += 1 * 3.1415 / 180;

	cube.Display(pDC->m_hDC, 0x00ffffff);

	cube.Rotate(ax, ay, az);
/*coordinate axes
	DrawLine(pDC->m_hDC, o->sx, o->sy, ox->sx, ox->sy, 0x000000ff);
	DrawLine(pDC->m_hDC, o->sx, o->sy, oy->sx, oy->sy, 0x000000ff);
	DrawLine(pDC->m_hDC, o->sx, o->sy, oz->sx, oz->sy, 0x000000ff);
*/

/*
	//rotate around z axis
	float tx = x * cos(az) + y * sin(az);
	float ty =  - x * sin(az) + y * cos(az);
	float tz = z;

	//rotate around x axis
	float ttx = tx;
	float tty = ty * cos(ax) + tz * sin(ax);
	float ttz = - ty * sin(ax) + tz * cos(ax);
	
	//rotate around y axis
	float tttx = ttx * cos(ay) - ttz * sin(ay);
	float ttty = tty;
	float tttz = ttx * sin(ay) + ttz * cos(ay);


	int sx = (rect.Width() >> 1) + 256 * tttx / (tttz + 256);
	int sy = (rect.Height() >> 1) + 256 * ttty / (tttz + 256);
*/
	}

/* this is used to tell the main thread that this one is quiting
   otherwise when i try to destory the view it says: "document still alive",
   "memory leaks" etc */
	
	trig = 1; 

	AfxEndThread(0);

//	delete ox; delete oy; delete oz; delete o;
	return 0;
}

void CTestrotView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CDC * pDC = this->GetDC();

	trig = trig ^ 1;

	CWinThread * thread;

	if (trig)
		thread = AfxBeginThread(ThreadFunc, (LPVOID)pDC);
	else
	{
//		AfxMessageBox("thread stoped");
		Invalidate();
		::PostQuitMessage(0);
	}
}

void CTestrotView::OnCancelMode() 
{
	
}

void CTestrotView::OnCaptureChanged(CWnd *pWnd) 
{
	// TODO: Add your message handler code here
	
	CView::OnCaptureChanged(pWnd);
}

void CTestrotView::OnDestroy() 
{
/* to quit the thread i use trig = 0,
   so when i see that trig = 1 (assigned by the thread on quitting)
   this means that the thread has successfully quitted itself 
   and it's safe to destory the view 
   (actually i really wasn't sure if this is going to work, 
   but it does! :)  */

	while (!trig);

	CView::OnDestroy();
	
	
}

void CTestrotView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnChar(nChar, nRepCnt, nFlags);
}
