//simple openGL example by stoyan demirev, stoyan@mailcity.com

#include "object.h"
#include "gl/glut.h"

extern void normalize(GLfloat v[3]);
extern void normcrossprod(float v1[3], float v2[3], float out[3]);

object::object(char * from_file)
{
	//////// code from showasc.cpp - 3dStudio .asc file viewer
     //  by Zach Mortensen [Voltaire/OTM]

    FILE *inFile;
    int vertices, faces, count, vNum, tempA, tempB, tempC;
    char tempChar;
    float tempX, tempY, tempZ;

    char *tempStr = new char [80];

    inFile = fopen(from_file, "rt");
    if (inFile == NULL)
    {
        printf("%s does not exist!\n", from_file);
        printf("USAGE:  showasc <filename.asc>\n");
        exit(3);
    }

    // parse the input file, get the object data we're after

    while (strncmp(tempStr, "Vertices", 8))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
            exit(2);
        }
    }

//    printf("Found string: %s\n", tempStr);

    tempChar = fgetc(inFile);

    fscanf(inFile, "%d", &vertices);

//    printf("Object has %d vertices\n", vertices);

    while (strncmp(tempStr, "Faces", 5))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Faces\" NOT FOUND!!\n");
            exit(2);
        }
    }

//    printf("Found string: %s\n", tempStr);

    tempChar = fgetc(inFile);

    fscanf(inFile, "%d", &faces);

//    printf("Object has %d faces\n", faces);
	printf("Loading object : %d vertices, %d faces\n", vertices, faces);

    while (strncmp(tempStr, "Vertex", 6))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
            exit(2);
        }
    }

    while (strncmp(tempStr, "list:", 5))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"list:\" NOT FOUND!!\n");
            exit(2);
        }
    }

	v = new vertex[vertices + 1];
	f = new face[faces + 1];
	long current = 0;

//    printf("\nVertex data:\n");

 //   tempStr = "blah blah blah"; //somehow it gave errors with this init

    for (count = 0; count < vertices; count++)
    {
        while (strncmp(tempStr, "Vertex", 6))
        {
            fscanf(inFile, "%s", tempStr);
            if (feof(inFile))
            {
                printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
                exit(2);
            }
        }

        fscanf(inFile, "%d", &vNum);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempX);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempY);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempZ);

//        printf("Vertex %d:  %8d %8d %8d\n", vNum, (int) tempX, (int) tempY, (int) tempZ);

        // add points to objects


//in 3dsm z is up/down, y is out/in so swap'em
		v[current].x = (int) tempX;
		v[current].z = (int) tempY;
		v[current].y = (int) tempZ;

		v[current].z = - v[current].z; //'cause in 3dsm it is inverted

		current++;
    }

	current = 0;

    while (strncmp(tempStr, "Face", 4))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Face\" NOT FOUND!!\n");
            exit(2);
        }
    }

//    printf("\nFound string: %s\n", tempStr);

    while (strncmp(tempStr, "list", 4))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"list\" NOT FOUND!!\n");
            exit(2);
        }
    }

//    printf("Found string: %s\n", tempStr);

//    printf("\nFacial data:\n");

    for (count = 0; count < faces; count++)
    {
        while (strncmp(tempStr, "Face", 4))
        {
            fscanf(inFile, "%s", tempStr);
            if (feof(inFile))
            {
                printf("End-o-FILE and string \"Face\" NOT FOUND!!\n");
                exit(2);
            }
        }

        fscanf(inFile, "%d", &vNum);
        fscanf(inFile, "%s", tempStr);

        while (fgetc(inFile) != 'A');
        fgetc(inFile);                  // get the ':' character
        fscanf(inFile, "%d", &tempA);   // get value for vertex A

        while (fgetc(inFile) != 'B');
        fgetc(inFile);
        fscanf(inFile, "%d", &tempB);

        while (fgetc(inFile) != 'C');
        fgetc(inFile);
        fscanf(inFile, "%d", &tempC);

//        printf("Face %d:  %8d %8d %8d\n", vNum, (int) tempA, (int) tempB, (int) tempC);

        // add faces to objects

//swap y/z, if normal was used it should've been negated too ( norm = -norm )

		f[current].p1 = &v[tempA];
		f[current].p3 = &v[tempB];
		f[current].p2 = &v[tempC];

		current++;
    }

 
    fclose(inFile);

	this->vertices = vertices;
	this->faces = faces;
	
//	delete v;
	delete tempStr;

	rotx = roty = rotz = transz = transy = transx = 0;

//	rotz = 90;
	transx = 0;
	transy = 0;
	transz = 0;
	transz = 0;

	usetexture = false;
	fillmode = GL_LINE;
	scale = true;
	scale_coef = 0.1;

}


object::~object()
{
	if ( v != NULL) delete v;
	if ( f != NULL) delete f;

}

object::show()
{  

//	glMatrixMode (GL_MODELVIEW);
	glColor3f(r, g, b);	//yellow
//	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);
	glPushMatrix();

 //   glLoadIdentity (); must be out to have object * camera * world coords!

	if (scale) glScalef(scale_coef, scale_coef, scale_coef);//yop!otherwise its just too big...

//it looks like rotations MUST be done first to have proper object-world-camera space movement!
//i knew the order of execution matters, but finding this "bug" was harsh... ;)

	glRotatef(rotx, 1.0f, 0.0f, 0.0f);
	glRotatef(roty, 0.0f, 1.0f, 0.0f);
	glRotatef(rotz, 0.0f, 0.0f, 1.0f);
	glTranslatef(transx, transy, transz);


	if (usetexture) {
		glEnable (GL_TEXTURE_2D);
		glBindTexture (GL_TEXTURE_2D, 2);
	}

	glPolygonMode (GL_FRONT_AND_BACK, fillmode);

	float e1[3], e2[3], normal[3];

	glBegin(GL_TRIANGLES);
	for (int i = 0; i < faces; i++)
	{
		e1[0] = f[i].p2->x - f[i].p1->x;
		e1[1] = f[i].p2->y - f[i].p1->y;
		e1[2] = f[i].p2->z - f[i].p1->z;
		e2[0] = f[i].p2->x - f[i].p3->x;
		e2[1] = f[i].p2->y - f[i].p3->y;
		e2[2] = f[i].p2->z - f[i].p3->z;
		normcrossprod(e1, e2, normal);
		glNormal3fv(normal);

//	    glColor4f (1.0f, 1.0f, 1.0f, 1.0f);
		
		if (usetexture) glTexCoord2f (0,0);
		glVertex3f(f[i].p1->x, f[i].p1->y, f[i].p1->z);
		if (usetexture) glTexCoord2f (1,0);
		glVertex3f(f[i].p2->x, f[i].p2->y, f[i].p2->z);
        if (usetexture) glTexCoord2f (1,1);
		glVertex3f(f[i].p3->x, f[i].p3->y, f[i].p3->z);
	}
	glEnd();

	if (usetexture) glDisable (GL_TEXTURE_2D);

	glPopMatrix();
}

object::setenv(int tID, unsigned int  fillMode, bool bScale, float coef, float red, float green, float blue)
{
	if (tID < 0) 
		usetexture = false;
	else { usetexture = true; textureID = tID; }
	fillmode = fillMode;
	scale = bScale;
	scale_coef = coef;
	r = red; 
	g = green;
	b = blue;
}
