//simple openGL example by stoyan demirev, stoyan@mailcity.com

//skeleton of the code by Nate 'm|d' Miller (vandals1@home.com, http://members.home.com/vandals1)
//actually it's a basic GLUT skeleton, but nevertheless i hate to spare credits :)

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>
#include "tga.h"

#include "object.h"

int frames[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1, 0};  /* the frames for our animation */
int numFrames = sizeof (frames) / sizeof (frames[0]); /* number of frames in the animation */

int winW = 640;
int winH = 480;
int frameIndex = 0; /* index to the current frame we are at */
int redraw = 33; /* how often do we redraw, every 33 milliseconds, can change */
int isAlive = 1; /* are we alive and animating? */
clock_t appTicker; /* used for animation timing */

float angle = 0.0;
float dx = 0.0;

float camera_rotx = 0, camera_roty = 0, camera_rotz = 0, 
	  camera_transx = 0, camera_transy = 0, camera_transz = 0;//used to be (0, 33 -9999)

extern void load(char * argv);

object * duck;
object * tree;
object * xwing;

int wave = 3;
/*
=============
getClock
=============
    Returns the processor time that has elapsed.  
*/
clock_t getClock (void)
{
    return clock ();
}
/*
=============
drawQuad
=============
*/
void drawWater (void)
{
	glEnable (GL_TEXTURE_2D);
	if (wave) wave--;
		else wave = 3;
    glBindTexture (GL_TEXTURE_2D, wave);
	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);

    glColor4f (1.0f, 1.0f, 1.0f, 1.0f);

    glBegin (GL_QUADS);
        glTexCoord2f (0,0);
        glVertex3f (-1000, -100, -1000);
        glTexCoord2f (1,0);
        glVertex3f (1000, -100, -1000);
        glTexCoord2f (1,1);
        glVertex3f (1000, -100, 1000);
        glTexCoord2f (0,1);
        glVertex3f (-1000, -100, 1000);
    glEnd ();
	glDisable (GL_TEXTURE_2D);

}
/*
=============
glutDisplay
=============
    Our display function.
*/
void glutDisplay (void)
{
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //must clear the DEPTH_BUFFER TOOOOOOOOOOOO!

    drawWater (); /* draw the water texture */

	glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();

	gluPerspective (90, winW / winH, 1, 10000);

	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();

	glTranslatef(camera_transx, camera_transy, camera_transz);

	glRotatef(camera_rotx, 1.0f, 0.0f, 0.0f);
	glRotatef(camera_roty, 0.0f, 1.0f, 0.0f);
	glRotatef(camera_rotz, 0.0f, 0.0f, 1.0f);

	glEnable(GL_CULL_FACE);
	glCullFace(GL_FRONT); 

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);

	duck->show();
	duck->transz -= 5;
	duck->roty += 0.05;

	tree->show(); 

	xwing->show();
	xwing->transz += 25;
	if (xwing->transz > 1000)
		xwing->transz = -3000;


	glutSwapBuffers();

	glDisable(GL_DEPTH_TEST);

	glDisable(GL_CULL_FACE);

}
/*
=============
gludIdleFunc
=============
    Function that is called when we are idle.  Advances the animation frame at 
the correct time.  
*/
void glutIdle (void)
{
    clock_t current = getClock ();

    if (current > appTicker && isAlive)
    {
        frameIndex ++;
        if (frameIndex >= numFrames)
            frameIndex = 0;

        glutPostRedisplay ();
        appTicker = getClock () + redraw;
    }
}
/*
=============
glutResize
=============
    Called when the window is resized.
*/
void glutResize (int w, int h)
{
    winW = w;
    winH = h;

    glViewport (0, 0, w, h);

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();

    glOrtho (-w, w, -h, h, -1, 1);

    glutPostRedisplay ();
}
/*
=============
glutKeyboard
=============
    Handles our keyboard input.
*/
void glutKeyboard (unsigned char key, int x, int y)
{
    switch (key)
    {
        case '=':
            redraw --;

            if (redraw <= 0)
                redraw = 1;
        break;
        case '-':
            redraw ++;
        break;
        case ' ':
            isAlive = !isAlive;
        break;
		case 's':
			duck->transz += 100;
		break;
		case 'k':
			duck->transz -= 100;
		break;
		case 'j':	
			duck->transx += 100;
		break;
		case 'a':
			duck->transx -= 100;
		break;
		case 'd':
			duck->transy += 100;
		break;
		case 'l':
			duck->transy -= 100;
		break;
		case 'w':
			duck->rotz += 25 * 3.1415 / 180;
		break;
		case 'i':
			duck->rotz -= 25 * 3.1415 / 180;
		break;
		case 'q':
			duck->rotx += 25 * 3.1415 / 180;
		break;
		case 'u':
			duck->rotx -= 25 * 3.1415 / 180;
		break;
		case 'e':
			duck->roty += 25 * 3.1415 / 180;
		break;
		case 'o':
			duck->roty -= 25 * 3.1415 / 180;
		break;

		case 'x':
			camera_transz += 100;
		break;
		case 'n':
			camera_transz -= 100;
		break;
		case 'z':
			camera_roty += 25 * 3.1415 / 180;
		break;
		case 'b':
			camera_roty -= 25 * 3.1415 / 180;
		break;
		case 'c':
			camera_transy += 100;
		break;
		case 'm':
			camera_transy -= 100;
		break;



    }
    glutPostRedisplay ();
}
/*
=============
glutAppInit
=============
    Called when the app starts.  Loads the frames of our animation and the font. 
The application ticker is also started.
*/
void glutAppInit (void)
{
	loadTGA("water1.tga", 0);
	loadTGA("water2.tga", 1);
	loadTGA("water3.tga", 2);
	loadTGA("water4.tga", 3);
	loadTGA("duck.tga", 4);
  
    appTicker = getClock () + redraw;
}   

void glutDie (void)
{
	if (duck != NULL) delete duck;
	if (tree != NULL) delete tree;
	if (xwing != NULL) delete xwing;
}

void glInit (void)
{
    float lightAmbient[] = {0.1, 0.3, 0.3, 1.0};
	float lightDiffuse[] = {1.0, 1.0, 1.0, 1.0};
	float lightSpecular[] = {1.0, 1.0, 1.0, 1.0};

	glLightfv (GL_LIGHT0, GL_AMBIENT, lightAmbient);
    glLightfv (GL_LIGHT0, GL_DIFFUSE, lightDiffuse);
    glLightfv (GL_LIGHT0, GL_SPECULAR, lightSpecular);

	GLfloat light_position[] = { 1.0, 100.0, 1.0, 0.0 };

	glLightfv(GL_LIGHT0, GL_POSITION, light_position);

//   glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
}

void main (void)
{
    glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
    glutInitWindowSize (winW, winH);
    glutCreateWindow ("gl2");
    glutDisplayFunc (glutDisplay);
    glutReshapeFunc (glutResize);
    glutIdleFunc (glutIdle);
    glutKeyboardFunc (glutKeyboard);
	glInit();

    glutAppInit ();
    
//	load("duck.asc");

	duck = new object("duck.asc");
	duck->setenv(-1, GL_FILL, true, 0.1, .8, .8, 0);
	
	tree = new object("birch02.asc");
	tree->setenv(-1, GL_FILL, true, 6, .5, .6, .0);
	tree->transy = 17; //get it on one level with the duck
	tree->transx = 150;
	tree->transz = 0;

	xwing = new object("xwing.asc");
	xwing->setenv(-1, GL_FILL, true, 2, .3, .2, .8);

	xwing->transy = 250;
	xwing->transz = -3000;

    glutMainLoop();
}

#include "math.h"

void normalize(float v[3])
{
	float d = sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
	if(d == 0.0)
	{
		return;
	}
	v[0] /= d; v[1] /= d; v[2] /= d;
}

void normcrossprod(float v1[3], float v2[3], float norm[3])
{
	norm[0] = v1[1]*v2[2] - v1[2]*v2[1];
	norm[1] = v1[2]*v2[0] - v1[0]*v2[2];
	norm[2] = v1[0]*v2[1] - v1[1]*v2[0];
	normalize(norm);
}
