/*
DISCLAMIER:
This software is provided "as is". You use it at your own risk, I'm
not responsible for misuse or any kind of direct/indirect damage
attributable to the software in question.

NOTES:
The archive containing this file is Public Domain material. You can use
it as you want as long as you don't sell it.
You are free to use the source code as long as you don't modify and
redistriubuite it to grant credits for yourself. 

Have fun

sayshell

stoyan demirev
stoyan@mailcity.com

*/

#include "globals.h"

extern Cube cube, dube;
double ax = 5 * 3.1415 / 180, ay = 5 * 3.1415 / 180, az = 5 * 3.1415 / 180;
extern UCHAR * video_buffer;
extern long pitch;

void Game_Init(void)
{
	cube.points[0].x = 40; cube.points[0].y = 40; cube.points[0].z = -40;
	cube.points[1].x = -40; cube.points[1].y = 40; cube.points[1].z = -40;
	cube.points[2].x = -40; cube.points[2].y = -40; cube.points[2].z = -40;
	cube.points[3].x = 40; cube.points[3].y = -40; cube.points[3].z = -40;
	cube.points[4].x = 40; cube.points[4].y = 40; cube.points[4].z = 40;
	cube.points[5].x = -40; cube.points[5].y = 40; cube.points[5].z = 40;
	cube.points[6].x = -40; cube.points[6].y = -40; cube.points[6].z = 40;
	cube.points[7].x = 40; cube.points[7].y = -40; cube.points[7].z = 40;

	cube.transformed[0].x = 40; cube.transformed[0].y = 40; cube.transformed[0].z = -40;
	cube.transformed[1].x = -40; cube.transformed[1].y = 40; cube.transformed[1].z = -40;
	cube.transformed[2].x = -40; cube.transformed[2].y = -40; cube.transformed[2].z = -40;
	cube.transformed[3].x = 40; cube.transformed[3].y = -40; cube.transformed[3].z = -40;
	cube.transformed[4].x = 40; cube.transformed[4].y = 40; cube.transformed[4].z = 40;
	cube.transformed[5].x = -40; cube.transformed[5].y = 40; cube.transformed[5].z = 40;
	cube.transformed[6].x = -40; cube.transformed[6].y = -40; cube.transformed[6].z = 40;
	cube.transformed[7].x = 40; cube.transformed[7].y = -40; cube.transformed[7].z = 40;

	cube.PointsToFaces();
	cube.InitNormals();
	cube.InitFakeNormals();

	dube.points[0].x = 40; dube.points[0].y = 40; dube.points[0].z = -40;
	dube.points[1].x = -40; dube.points[1].y = 40; dube.points[1].z = -40;
	dube.points[2].x = -40; dube.points[2].y = -40; dube.points[2].z = -40;
	dube.points[3].x = 40; dube.points[3].y = -40; dube.points[3].z = -40;
	dube.points[4].x = 40; dube.points[4].y = 40; dube.points[4].z = 40;
	dube.points[5].x = -40; dube.points[5].y = 40; dube.points[5].z = 40;
	dube.points[6].x = -40; dube.points[6].y = -40; dube.points[6].z = 40;
	dube.points[7].x = 40; dube.points[7].y = -40; dube.points[7].z = 40;

	dube.transformed[0].x = 40; dube.transformed[0].y = 40; dube.transformed[0].z = -40;
	dube.transformed[1].x = -40; dube.transformed[1].y = 40; dube.transformed[1].z = -40;
	dube.transformed[2].x = -40; dube.transformed[2].y = -40; dube.transformed[2].z = -40;
	dube.transformed[3].x = 40; dube.transformed[3].y = -40; dube.transformed[3].z = -40;
	dube.transformed[4].x = 40; dube.transformed[4].y = 40; dube.transformed[4].z = 40;
	dube.transformed[5].x = -40; dube.transformed[5].y = 40; dube.transformed[5].z = 40;
	dube.transformed[6].x = -40; dube.transformed[6].y = -40; dube.transformed[6].z = 40;
	dube.transformed[7].x = 40; dube.transformed[7].y = -40; dube.transformed[7].z = 40;

	dube.PointsToFaces();
	dube.InitNormals();
	dube.InitFakeNormals();

}
void Game_Shutdown(void)
{

} 

/*

void Game_Main(HWND hwnd)
{

	if (KEY_DOWN(VK_ESCAPE))
		PostMessage(hwnd,WM_CLOSE,0,0); 
	if (KEY_DOWN(VK_RIGHT))
		for (int i = 0; i < 8; i++)
			cube.points[i].x += 5;

//if (KEY_DOWN(VK_LEFT))

//if (KEY_DOWN(VK_UP))

//if (KEY_DOWN(VK_DOWN))

	cube.Project(128, 128);
	cube.Display(0x000000ff);

	
	Sleep(50); 

	az += 5 * 3.1415 / 180;
	ax += 3 * 3.1415 / 180;
	ay += 1 * 3.1415 / 180;
 
	cube.Display(0x00000000);

	cube.Rotate(ax, ay, az);
} 

*/

void PutPixel(int x, int y, long col)
{
	video_buffer[x + y * pitch] = col;
}

void DrawLine(int x1, int y1, int x2, int y2, long col)
{
	int xadd1 = 1, yadd1 = 1, xadd2 = 1, yadd2 = 1;
	int p, q, s, x = x1, y = y1;

	p = y1 - y2; q = x1 - x2;

	if (p > 0) {yadd1 = yadd2 = -1;} else if (!p) yadd1 =yadd2 =0;
	if (q > 0) {xadd1 = xadd2 = -1;} else if (!q) xadd1 =xadd2 =0;

	p = abs(p);
	q = abs(q);
	if (q > p) 
		yadd2 = 0;
	else 
	{
		xadd2 = 0;
		SWAP(p, q);
	}

	s = p - q / 2;
	for (int i = 0; i < q + 1; i++)
	{
		PutPixel(x, y, col);
		if (s > 0) 
		{
			x += xadd1; 
			y += yadd1;
			s += p - q;
		}
		else	
		{
			x += xadd2;
			y += yadd2;
			s += p;
		}
	}
}

/* a simple polifiller - get two buffers.start scanning for intersection with
polys ribs/edges; then put a line between'em

  here and everywhere the "height" param is obsolete - nevermind
*/
void PoliFiller(POINT p[5], int Height, long color)//5 points - to connect the first with the last
{
	int * left  = new int [Height];
	int * right = new int [Height];

	for (int j = 0; j < Height; j++) left[j] = 1000;
	memset(right, -1, Height);

	for (int i = 0; i < 4; i++)
	{
		POINT p1 = p[i];
		POINT p2 = p[i + 1];

		if (p1.y > p2.y)
		{
			SWAP(p1.x, p2.x);
			SWAP(p1.y, p2.y);
		}

		float dx = float(p2.x - p1.x) / float(p2.y - p1.y);
		float x = p1.x;

		for (int y = p1.y; y < p2.y; y++)
		{
			if (x < left[y]) 
				left[y]  = x;
			if (x > right[y]) 
				right[y] = x;

			x += dx;
		}

	}

	for (i = 0; i < Height; i++)
		if (left[i] < 1000 && right[i] > -1)
		{
			DrawLine(left[i], i, right[i], i, color);
		}


	delete left;
	delete right;
}

/*  based on the above: again two buffers, again scan for intersection.
	this time we also interpolate along the edges with values from the 
	vertices,they come from the fake normals; once we have all values along the edges
	we start interpolating along the scanlines.
	that's basicly what's gouraud about...got it?no?hmmm...
*/

void GouraudFiller(cPOINT p[5], int Height)//5 points - to connect the first with the last
{
	int * left  = new int [Height];
	float * left_colors = new float [Height];
	int * right = new int [Height];
	float * right_colors = new float [Height];

	for (int j = 0; j < Height; j++) left[j] = 1000;
	memset(right, -1, Height);

	for (int i = 0; i < 4; i++)
	{
		cPOINT p1 = {p[i].p.x, p[i].p.y, p[i].c};
		cPOINT p2 = {p[i + 1].p.x, p[i + 1].p.y, p[i + 1].c};

		if (p1.p.y > p2.p.y)
		{
			SWAP(p1.p.x, p2.p.x);
			SWAP(p1.p.y, p2.p.y);
			SWAP(p1.c, p2.c);
		}

		float dx = float(p2.p.x - p1.p.x) / float(p2.p.y - p1.p.y);
		float dyc = float(p2.c - p1.c) / float(p2.p.y - p1.p.y);
		float x = p1.p.x;
		float c = p1.c;

//start interpolating downside the edges

		for (int y = p1.p.y; y < p2.p.y; y++)
		{
			if (x < left[y])
			{
				left[y]  = x;
				left_colors[y] = c;
			}
			if (x > right[y]) 
			{
				right[y] = x;
				right_colors[y] = c;
			}

			x += dx;
			c += dyc;
		}

	}

//start interpolating along the scanlines

	for (i = 0; i < Height; i++)
		if (left[i] < 1000 && right[i] > -1)
		{
			float dxc = float(right_colors[i] - left_colors[i]) / float(right[i] - left[i]);
			float c = left_colors[i];

			for (int x = left[i]; x < right[i]; x++)
			{
//				if (c < 0) c = 0;
				PutPixel(x, i, c);
				c += dxc;
			}

		}


	delete left;
	delete right;
	delete left_colors;
	delete right_colors;
}

/* and here are the two buffers again
   here we have two kinds of coords : say face coords, and coords of
   the texture that's going (hopefully) to be mapped on it
   again we interpolate first along the edges, and then along the scan line   
*/

void TextureMapper(TEXTURE * tmap, tPOINT p[5], int Height)//5 points - to connect the first with the last
{
	TEXTURE * texture = tmap;

	int * left  = new int [Height];
	float * left_Us	 = new float [Height];
	float * left_Vs  = new float [Height];
	float * right_Us = new float [Height];
	float * right_Vs = new float [Height];
	int * right = new int [Height];	

	for (int j = 0; j < Height; j++) left[j] = 1000;
	memset(right, -1, Height);

	for (int i = 0; i < 4; i++)
	{
		tPOINT p1 = {p[i].p.x, p[i].p.y, p[i].U, p[i].V};
		tPOINT p2 = {p[i + 1].p.x, p[i + 1].p.y, p[i + 1].U, p[i + 1].V};

		if (p1.p.y > p2.p.y)
		{
			SWAP(p1.p.x, p2.p.x);
			SWAP(p1.p.y, p2.p.y);
			SWAP(p1.U, p2.U);
			SWAP(p1.V, p2.V);
		}

		float dy = float(p2.p.y - p1.p.y);
		float dx, dUy, dVy;

		if (dy != 0)
		{
			dx = float(p2.p.x - p1.p.x) / dy;
			dUy = float(p2.U - p1.U) / dy;
			dVy = float(p2.V - p1.V) / dy;
		}
		else 
		{
			dx = 0;
			dUy = 0;
			dVy = 0;
		}

		float x = p1.p.x;
		float U = p1.U;
		float V = p1.V;

//start interpolating downside the edges

		for (int y = p1.p.y; y <= p2.p.y; y++)//used to be y < p2.p.y, instead of <=
		{
			if (x <= left[y])
			{
				left[y]  = x;
				left_Us[y] = U;
				left_Vs[y] = V;
			}
			if (x >= right[y]) 
			{
				right[y] = x;
				right_Us[y] = U;
				right_Vs[y] = V;
			}

			x += dx;
			U += dUy;
			V += dVy;
		}

	}

//start interpolating along the scanlines

	for (i = 0; i < Height; i++)
		if (left[i] < 1000 && right[i] > -1)
		{
			float di = float(right[i] - left[i]);
			float dUx, dVx;

			if (di != 0)
			{
				dUx = float(right_Us[i] - left_Us[i]) / di;
				dVx = float(right_Vs[i] - left_Vs[i]) / di;			
			}
			else 
			{
				dUx = float(right_Us[i] - left_Us[i]);
				dVx = float(right_Vs[i] - left_Vs[i]);
			}

			float U	  = left_Us[i];
			float V   = left_Vs[i];

			for (int x = left[i]; x <= right[i]; x++)
			{
				int texel = U + (int)V * texture->width;//V MUST be converted to INT! this bug was quite difficult to find!
				long color = (long)texture->tmap[texel];
				PutPixel(x, i, color);
				U += dUx;
				V += dVx;
			}

		}


	delete left;
	delete right;
	delete left_Us;
	delete right_Vs;
}