/*
DISCLAMIER:
This software is provided "as is". You use it at your own risk, I'm
not responsible for misuse or any kind of direct/indirect damage
attributable to the software in question.

NOTES:
The archive containing this file is Public Domain material. You can use
it as you want as long as you don't sell it.
You are free to use the source code as long as you don't modify and
redistriubuite it to grant credits for yourself. 

Have fun

sayshell

stoyan demirev
stoyan@mailcity.com

*/
// Face3d.cpp: implementation of the Face3d class.
//
//////////////////////////////////////////////////////////////////////

#include "Face3d.h"
#include "windows.h"
#include "math.h"
#include "globals.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

extern void DrawLine(int x1, int y1, int x2, int y2, long color);
extern void PoliFiller(POINT p[], int Height, long color);
extern unsigned char * texture;

void Face3d::Display(unsigned char type, long color)
{
	long c = 0;
	Point3d light(1, 1, 150);
	float length = 0;

    float D = normal->x * p2->x + normal->y * p2->y + normal->z * p2->z;

	if (normal->z * VIEW_DISTANCE - D < 0) return;
	
	switch(type) {

	case TEXTURED :
		
		DisplayTextured(texture, color, 1000);
		break;	

	case GOURAUD :

		length = sqrt(light.x * light.x + light.y * light.y + light.z * light.z);

		light.x = float(light.x / length);
		light.y = float(light.y / length);
		light.z = float(light.z / length);

		DisplayGouraud(light, color, 1000);
		break;	

	case LAMBERT :

		c = ((int)((color & 0xff) * normal->z)) >> 2 | ((int)((color & 0xff00) * normal->z)) >> 4 | ((int)((color & 0xff0000) * normal->z)) >> 6;
		DisplayColored(c, 1000); 
		break;

	case WIREFRAME :

		DrawLine(p1->sx, p1->sy, p2->sx, p2->sy, color);
		DrawLine(p2->sx, p2->sy, p3->sx, p3->sy, color);
		DrawLine(p3->sx, p3->sy, p4->sx, p4->sy, color);
		DrawLine(p4->sx, p4->sy, p1->sx, p1->sy, color);
		break;
	}
}

void Face3d::DisplayColored(long color, int height)
{
	POINT p[5] = {{p1->sx, p1->sy}, {p2->sx, p2->sy}, {p3->sx, p3->sy}, {p4->sx, p4->sy}, {p1->sx, p1->sy}};
	PoliFiller(p, height, color);
}


void Face3d::DisplayGouraud(Point3d LightVector, long color, int height)
{
	float dotProduct1, dotProduct2, dotProduct3, dotProduct4;

	dotProduct1 = p1->nx * LightVector.x + p1->ny * LightVector.y + p1->nz * LightVector.z;

	dotProduct2 = p2->nx * LightVector.x + p2->ny * LightVector.y + p2->nz * LightVector.z;

	dotProduct3 = p3->nx * LightVector.x + p3->ny * LightVector.y + p3->nz * LightVector.z;

	dotProduct4 = p4->nx * LightVector.x + p4->ny * LightVector.y + p4->nz * LightVector.z;

//without this check - multi problemo

	dotProduct1 = dotProduct1 < 0 ? 0 : dotProduct1;
	dotProduct2 = dotProduct2 < 0 ? 0 : dotProduct2;
	dotProduct3 = dotProduct3 < 0 ? 0 : dotProduct3;
	dotProduct4 = dotProduct4 < 0 ? 0 : dotProduct4;

	cPOINT p[5] = {{p1->sx, p1->sy, color * dotProduct1}, {p2->sx, p2->sy, color * dotProduct2},
		           {p3->sx, p3->sy, color * dotProduct3}, {p4->sx, p4->sy, color * dotProduct4},
					{p1->sx, p1->sy, color * dotProduct1}}; //have a closed circle of points

	GouraudFiller(p, height);
}


void Face3d::DisplayTextured(unsigned char * tmap, long color, long height)
{
	TEXTURE t = {tmap, 128, 128};

	tPOINT p[5] = {{p1->sx, p1->sy, 0, 0}, {p2->sx, p2->sy, 127, 0},
		           {p3->sx, p3->sy, 127, 127}, {p4->sx, p4->sy, 0, 127},
					{p1->sx, p1->sy, 0, 0}}; //have a closed circle of points
	
	TextureMapper(&t, p, height);
}
