/*
DISCLAMIER:
This software is provided "as is". You use it at your own risk, I'm
not responsible for misuse or any kind of direct/indirect damage
attributable to the software in question.

NOTES:
The archive containing this file is Public Domain material. You can use
it as you want as long as you don't sell it.
You are free to use the source code as long as you don't modify and
redistriubuite it to grant credits for yourself. 

Have fun

sayshell

stoyan demirev
stoyan@mailcity.com

*/
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <float.h>

#include "dx2Main.h"  

LPDIRECTDRAW lpDD;
LPDIRECTDRAWSURFACE lpDDSPrimary; 
LPDIRECTDRAWSURFACE lpDDSBack; 
LPDIRECTDRAWSURFACE sprite = NULL; 
LPDIRECTDRAWCLIPPER lpClipper;
DDSURFACEDESC ddsd;
LPDIRECTDRAWPALETTE lpDDPalette = NULL;
PALETTEENTRY color_palette[256];

IDirectDrawSurface * DDLoadBitmap(IDirectDraw *pdd, LPCSTR szBitmap);
IDirectDrawSurface * CreateOffScreenSurface(IDirectDraw *pdd, int dx, int dy);
HRESULT DDCopyBitmap(IDirectDrawSurface *pdds, HBITMAP hbm, int dx, int dy);

#ifdef _DEBUG
char IsWindowed = 0;
#else
char IsWindowed = 0;
#endif

BOOL active = false;
UCHAR * video_buffer;
long pitch;
unsigned char * texture = NULL;

#define HEIGHT 480
#define WIDTH 640

extern double ax, ay, az;

long k = 0, l = 0;

Cube cube, dube;

HRESULT RestoreAll()
{
	HRESULT ddrval;
	ddrval = lpDDSPrimary->Restore();
	return ddrval;
}

bool DirectDrawInitFullScreen(HWND hwnd)
{
    HRESULT ddrval;
    ddrval = DirectDrawCreate( NULL, &lpDD, NULL );
    if( ddrval != DD_OK )
    {
        return(false);
    }
  
	ddrval = lpDD->SetCooperativeLevel( hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
    if( ddrval != DD_OK )
    {
        lpDD->Release();
        return(false);
    }

    ddrval = lpDD->SetDisplayMode( WIDTH, HEIGHT, 8);
    if( ddrval != DD_OK )
    {
        lpDD->Release();
        return(false);
    }

	sprite = DDLoadBitmap(lpDD, "dx2.bmp");
	if (sprite == NULL) 
    {
        lpDD->Release();
		MessageBox(NULL, "no bmp!", "a!", 0);
        return(false);
    }

    return(true);
}

bool CreatePrimarySurface()
{
    DDSURFACEDESC ddsd;
    DDSCAPS ddscaps;
    HRESULT ddrval;

    memset( &ddsd, 0, sizeof(ddsd) );
    ddsd.dwSize = sizeof( ddsd );

    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;

    ddrval = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
    if( ddrval != DD_OK )
    {
        lpDD->Release();
        return(false);
    }

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    ddrval = lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);
    if( ddrval != DD_OK )
    {
        lpDDSPrimary->Release();
        lpDD->Release();
        return(false);
    }

    return true;
}

void updateFrame( void )
{

} 

void finiObjects( void )
{
    if( lpDD != NULL )
    {
        if( lpDDSBack != NULL )
        {
            lpDDSBack->Release();
            lpDDSBack = NULL;
        }

        if( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }

	lpDD->Release();
	lpDD = NULL;
	}
}

bool DirectDrawInitWindowed(THIS_ HWND hwnd)
{
    DDSURFACEDESC ddsd;
    DDSCAPS ddscaps;
    HRESULT ddrval;
 
    IsWindowed = true;

    ddrval = DirectDrawCreate( NULL, &lpDD, NULL );
    if( ddrval != DD_OK )
    { 
        return(false);
    }
 
    ddrval = lpDD->SetCooperativeLevel( hwnd, DDSCL_NORMAL );
    if( ddrval != DD_OK )
    {
        lpDD->Release();
        return(false);
    }

    memset( &ddsd, 0, sizeof(ddsd) );
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

    ddrval = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
    if( ddrval != DD_OK )
    {
        lpDD->Release();
        return(false);
    }

    ddrval = lpDD->CreateClipper( 0, &lpClipper, NULL );
    if( ddrval != DD_OK )
    {
        lpDDSPrimary->Release();
        lpDD->Release();
        return(false);
    }

    ddrval = lpClipper->SetHWnd( 0, hwnd );
    if( ddrval != DD_OK )
    {
        lpClipper-> Release();
        lpDDSPrimary->Release();
        lpDD->Release();
        return(false);
    }

    ddrval = lpDDSPrimary->SetClipper( lpClipper );
    if( ddrval != DD_OK )
    {
        lpClipper-> Release();
        lpDDSPrimary->Release();
        lpDD->Release();
        return(false);
    }

    memset( &ddsd, 0, sizeof(ddsd) );
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = WIDTH;
    ddsd.dwHeight = HEIGHT;

    ddrval = lpDD->CreateSurface( &ddsd, &lpDDSBack, NULL );
    if( ddrval != DD_OK )
    {
        lpClipper-> Release();
        lpDDSPrimary->Release();
        lpDD->Release();
        return(false);
    }

	sprite = DDLoadBitmap(lpDD, "dx2.bmp");
	if (sprite == NULL) 
    {
        lpDD->Release();
		MessageBox(hwnd, "no bmp!", "a!", 0);
        return(false);
    }

    return(true);
}

bool Flip(HWND ddWnd)
{
    HRESULT ddrval;
    RECT rcRectSrc;
    RECT rcRectDest;
    POINT p;

    if (IsWindowed)
    {
        p.x = 0; p.y = 0;
        ClientToScreen(ddWnd, &p);
        GetClientRect(ddWnd, &rcRectDest);
        OffsetRect(&rcRectDest, p.x, p.y);
        SetRect(&rcRectSrc, 0, 0, WIDTH, HEIGHT);
        ddrval = lpDDSPrimary->Blt( &rcRectDest, lpDDSBack, &rcRectSrc, DDBLT_WAIT, NULL);
    } else {
        ddrval = lpDDSPrimary->Flip( NULL, DDFLIP_WAIT);
    }

    return (ddrval == DD_OK);
}

/* code by Lar Mader follows: three functions
 * Function to create an offscreen surface and load a bitmap from
 * disk into it. The szBitmap field is the filename of the Bitmap.
 */
IDirectDrawSurface * DDLoadBitmap(IDirectDraw *pdd, LPCSTR szBitmap)
{
    HBITMAP hbm;
    BITMAP bm;
    IDirectDrawSurface *pdds;

    // LoadImage has some added functionality in Windows 95 that allows
    // you to load a bitmap from a file on disk.
    hbm = (HBITMAP)LoadImage(NULL, szBitmap, IMAGE_BITMAP, 0, 0,
    LR_LOADFROMFILE|LR_CREATEDIBSECTION);

    if (hbm == NULL)
        return NULL;

    GetObject(hbm, sizeof(bm), &bm); // get size of bitmap

   /*
    * create a DirectDrawSurface for this bitmap
    * source to function CreateOffScreenSurface() follows immediately
    */

    pdds = CreateOffScreenSurface(pdd, bm.bmWidth, bm.bmHeight);
    if (pdds) {
        DDCopyBitmap(pdds, hbm, bm.bmWidth, bm.bmHeight);
    }

    DeleteObject(hbm);

    return pdds;
}

/*
 * Creates a DirectDraw Surface of a specified size
 * This surface will be in video memory if enough is
 * available, otherwise it will be created in system memory
 */
IDirectDrawSurface * CreateOffScreenSurface(IDirectDraw *pdd, int dx, int dy)
{
    DDSURFACEDESC ddsd;
    IDirectDrawSurface *pdds;

    //
    // create a DirectDrawSurface for this bitmap
    //
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = dx;
    ddsd.dwHeight = dy;

    if (pdd->CreateSurface(&ddsd, &pdds, NULL) != DD_OK)
    {
        return NULL;
    } else {
        return pdds;
    }
}

/*
 * This function copies a previously loaded bitmap into a DirectDraw surface.
 * Notice that we can obtain a GDI style device context for a
 * DirectDraw surface, with which to BitBlt the bitmap into the
 * surface.
 */
HRESULT DDCopyBitmap(IDirectDrawSurface *pdds, HBITMAP hbm, int dx, int dy)
{
    HDC hdcImage;
    HDC hdc;
    HRESULT hr;
    HBITMAP hbmOld;

    //
    // select bitmap into a memoryDC so we can use it.
    //
    hdcImage = CreateCompatibleDC(NULL);
    hbmOld = (HBITMAP)SelectObject(hdcImage, hbm);

    if ((hr = pdds->GetDC(&hdc)) == DD_OK)
    {
        BitBlt(hdc, 0, 0, dx, dy, hdcImage, 0, 0, SRCCOPY);
        pdds->ReleaseDC(hdc);
    }

    SelectObject(hdcImage, hbmOld);
    DeleteDC(hdcImage);

    return hr;
}

LRESULT CALLBACK WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{

	HDC hdc; 
	PAINTSTRUCT ps; 

	switch(msg)
	{
		case WM_CREATE:
	{

		return(0);
	}	break;

	case WM_ACTIVATEAPP:
		active = (BOOL)wparam;
	break;

	case WM_PAINT:
	{

		hdc = BeginPaint(hwnd, &ps);
		EndPaint(hwnd, &ps);
		return(0);
	}	break;
	
	case WM_DESTROY:
	{

		PostQuitMessage(0);
		return(0);
	}	break;
	
	default:break;
	
	} 

	return (DefWindowProc(hwnd, msg, wparam, lparam));
} 

int WINAPI WinMain( HINSTANCE hinstance, HINSTANCE hprevinstance, LPSTR lpcmdline, int ncmdshow)
{
	WNDCLASSEX winclass; 
	HWND hwnd; 
	MSG msg; 

	winclass.cbSize = sizeof(WNDCLASSEX);
	winclass.style = CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	winclass.lpfnWndProc = WindowProc;
	winclass.cbClsExtra = 0;
	winclass.cbWndExtra = 0;
	winclass.hInstance = hinstance;
	winclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	winclass.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	winclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	winclass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	winclass.lpszMenuName = NULL;
	winclass.lpszClassName = "dx2 class";

	if (!RegisterClassEx(&winclass))
		return(0);

	if (!(hwnd = CreateWindowEx(0, 
		"dx2 class", 
		"fancy title!", 
		WS_VISIBLE | WS_POPUP, 
		0 + IsWindowed * 100, 0 + IsWindowed * 100, 
		GetSystemMetrics(SM_CXSCREEN) >> 1, 
		GetSystemMetrics(SM_CYSCREEN) >> 1, 
		NULL, 
		NULL, 
		hinstance, 
		NULL))) 
	return(0);

	ShowCursor(0);

	if (!IsWindowed) 
	{
		if (!DirectDrawInitFullScreen(hwnd))
		{
			DestroyWindow(hwnd);
			return(0);
		} 

		if (!CreatePrimarySurface())
		{
			finiObjects();
			DestroyWindow(hwnd);
			return(0);
		}
	}
	else DirectDrawInitWindowed(hwnd);

//start setting palette
	memset(color_palette, 0, 256 * sizeof(PALETTEENTRY));
/*
	for (int index=0; index<256; index++)
	{

	if ((index / 64) == 0)
	{
		color_palette[index].peRed = index * 4;
		color_palette[index].peGreen = index * 4;
		color_palette[index].peBlue = index * 4;
	} 
	else
	if ((index / 64) == 1)
		color_palette[index].peRed = (index%64) * 4;
	else
	if ((index / 64) == 2)
		color_palette[index].peGreen = (index%64) * 4;
	else
	if ((index / 64) == 3)
		color_palette[index].peBlue = (index%64) * 4;
	color_palette[index].peFlags = PC_NOCOLLAPSE;
	} 
*/
	for (int index = 0; index < 64; index++)
	{
		color_palette[index].peRed = 0;
		color_palette[index].peGreen = index;
		color_palette[index].peBlue = 0;
		color_palette[index + 64].peRed = 0;
		color_palette[index + 64].peGreen = (index + 64);
		color_palette[index + 64].peBlue = 0;
		color_palette[index + 128].peRed = 0;
		color_palette[index + 128].peGreen = (index + 128);
		color_palette[index + 128].peBlue = 0;
		color_palette[255 - index].peRed = 0;
		color_palette[255 - index].peGreen = (255 - index);
		color_palette[255 - index].peBlue = 0;
	}

	if (lpDD->CreatePalette((DDPCAPS_8BIT | DDPCAPS_INITIALIZE), color_palette, &lpDDPalette, NULL) != DD_OK)
	{
		finiObjects();
		return(0);
	} 

	lpDDSPrimary->SetPalette(lpDDPalette);
//end setting palette

	Game_Init();

	DDBLTFX ddbltfx;
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = 0;
	lpDDSBack->Blt(NULL,NULL,NULL,DDBLT_COLORFILL | DDBLT_WAIT,&ddbltfx);


	memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	HRESULT hr = 1;
	while (hr != DD_OK) {
	hr = sprite->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR, NULL);

	if (hr == DDERR_SURFACELOST)
	{
		sprite->Restore();
		sprite = DDLoadBitmap(lpDD, "dx2.bmp");
		continue;
	}

	
	UCHAR * p = (UCHAR *)ddsd.lpSurface;
	if (p != NULL)
	{
		texture = new unsigned char[128 * 128];

		for (int i = 0; i < 128 * 128; i++)
		{
			texture[i] = *(p++);
		}
	}

	sprite->Unlock(NULL);
	}

	while(1)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{

			if (msg.message  ==  WM_QUIT)
				break;

			TranslateMessage(&msg);

			DispatchMessage(&msg);
		} 

	else
	{
		if (active) {

		if (lpDDSPrimary->IsLost() == DDERR_SURFACELOST)
			lpDDSPrimary->Restore();

		if (lpDDSBack->IsLost() == DDERR_SURFACELOST)
			lpDDSBack->Restore();

		if (sprite->IsLost() == DDERR_SURFACELOST)
		{
			sprite->Restore();
			sprite = DDLoadBitmap(lpDD, "dx2.bmp");
		}


		HRESULT stalin;

		memset(&ddsd, 0, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);

		stalin = lpDDSBack->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR, NULL);
		if (stalin == DD_OK)
		{

			video_buffer = (UCHAR * )ddsd.lpSurface;

			pitch = ddsd.lPitch;

			if (!video_buffer) return 0;
/*		
			for(int i = 0; i < WIDTH; i++)
				for (int j = 0 ; j < HEIGHT; j++)
			{
//				video_buffer[i + j * pitch] = (UCHAR)rand();
				PutPixel(i, j, (UCHAR)rand());
//				video_buffer++;
			}
*/
			 
//			Game_Main(hwnd);

			if (KEY_DOWN(VK_ESCAPE))
				PostMessage(hwnd,WM_CLOSE,0,0); 
			if (KEY_DOWN(VK_RIGHT))
				l +=5;				//k, l are test vars to see if there's a setpix problem
			if (KEY_DOWN(VK_LEFT))
				l -= 5;
			if (KEY_DOWN(VK_UP))
				k -= 5;
			if (KEY_DOWN(VK_DOWN))
				k += 5;

			cube.Project(228, 128);
			cube.Display(GOURAUD, 0x00000ff);

			dube.Project(456, 128);
			dube.Display(TEXTURED, 0x000000ff);

//			TextureMapper(&t, p, 1000);//used when i tested texturemapping

			for (int u = 0; u < 128; u++)
				for (int v = 0; v < 128; v++)
					PutPixel(u + l, v + k, texture[u + 128 * v]);

			lpDDSBack->Unlock(ddsd.lpSurface);	
			
			az += 5 * 3.1415 / 180;
			ax += 3 * 3.1415 / 180;
			ay += 1 * 3.1415 / 180;
	
//			stalin = lpDDSPrimary->Blt(NULL, lpDDSBack, NULL, NULL, NULL);

			RECT rcRect;
			SetRect(&rcRect, 0, 0, 128, 128);
/*			HRESULT ddrval = lpDDSBack->Blt(&rcRect, sprite, NULL, DDBLT_WAIT , NULL);

			if( ddrval != DD_OK )
			{
				return NULL;
			}
*/
			Flip(hwnd);

			cube.Rotate(ax, ay, az);
			dube.Rotate(ax, ay, az);

			ddbltfx.dwSize = sizeof(ddbltfx);
			ddbltfx.dwFillColor = 0;
			lpDDSBack->Blt(NULL,NULL,NULL,DDBLT_COLORFILL | DDBLT_WAIT,&ddbltfx);
		
			if( stalin == DDERR_SURFACELOST )
				stalin = RestoreAll();
/*			
			HDC hdc = NULL;
			lpDDSPrimary->GetDC(&hdc);
			if (hdc) 
			{
				POINT p = {10, 450};
				ClientToScreen(hwnd, &p);
				SetBkColor(hdc, 0);
				SetTextColor(hdc, 0x00ffffff);
				char str[] = "so far : rotating, backsurface removing, flat filling, lambert shading, Gouraud shading";
				TextOut(hdc, p.x, p.y, str, strlen(str));
				lpDDSPrimary->ReleaseDC(hdc);
			}
*/
			Sleep(50);
		}
	} 
	}
	} 

	finiObjects();

	delete texture;

	return(msg.wParam);
} 

