/*
DISCLAMIER:
This software is provided "as is". You use it at your own risk, I'm
not responsible for misuse or any kind of direct/indirect damage
attributable to the software in question.

NOTES:
The archive containing this file is Public Domain material. You can use
it as you want as long as you don't sell it.
You are free to use the source code as long as you don't modify and
redistriubuite it to grant credits for yourself. 

Have fun

sayshell

stoyan demirev
stoyan@mailcity.com

*/
// Cube.cpp: implementation of the Cube class.
//
//////////////////////////////////////////////////////////////////////

#include "Cube.h"
#include "math.h"
#include "globals.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Cube::PointsToFaces() //in clockwise order
{
	Point3d * tp1 = new Point3d(), * tp2 = new Point3d();

	//back
	faces[0].p1 = &transformed[0];
	faces[0].p2 = &transformed[3];
	faces[0].p3 = &transformed[2];
	faces[0].p4 = &transformed[1];
	faces[0].normal = &transformed[8];//to utilate rotating, normals are included in points list, starting from 8

	//front
	faces[1].p1 = &transformed[4];
	faces[1].p2 = &transformed[5];
	faces[1].p3 = &transformed[6];
	faces[1].p4 = &transformed[7];
	faces[1].normal = &transformed[9];

	//right
	faces[2].p1 = &transformed[0];
	faces[2].p2 = &transformed[4];
	faces[2].p3 = &transformed[7];
	faces[2].p4 = &transformed[3];
	faces[2].normal = &transformed[10];

	//left
	faces[3].p1 = &transformed[5];
	faces[3].p2 = &transformed[1];
	faces[3].p3 = &transformed[2];
	faces[3].p4 = &transformed[6];
	faces[3].normal = &transformed[11];

	//bottom
	faces[4].p1 = &transformed[7];
	faces[4].p2 = &transformed[6];
	faces[4].p3 = &transformed[2];
	faces[4].p4 = &transformed[3];
	faces[4].normal = &transformed[12];

	//top
	faces[5].p1 = &transformed[0];
	faces[5].p2 = &transformed[1];
	faces[5].p3 = &transformed[5];
	faces[5].p4 = &transformed[4];
	faces[5].normal = &transformed[13];

}

Cube::Rotate(float ax, float ay, float az)
{
	Point3d tempBuffer1, tempBuffer2;

	for (int i = 0; i < 14; i++)
	{
		//rotate around x axis
		tempBuffer1.x = points[i].x;
		tempBuffer1.y = points[i].y * cos(ax) + points[i].z * sin(ax);
		tempBuffer1.z = - points[i].y * sin(ax) + points[i].z * cos(ax);
		
		//rotate around y axis
		tempBuffer2.x = tempBuffer1.x * cos(ay) - tempBuffer1.z * sin(ay);
		tempBuffer2.y = tempBuffer1.y;
		tempBuffer2.z = tempBuffer1.x * sin(ay) + tempBuffer1.z * cos(ay);

		//rotate around z axis
		transformed[i].x = tempBuffer2.x * cos(az) + tempBuffer2.y * sin(az);
		transformed[i].y =  - tempBuffer2.x * sin(az) + tempBuffer2.y * cos(az);
		transformed[i].z = tempBuffer2.z;
	}

//rotate the fake normals

	for (i = 0; i < 8; i++)
	{
		//rotate around x axis
		tempBuffer1.nx = points[i].nx;
		tempBuffer1.ny = points[i].ny * cos(ax) + points[i].nz * sin(ax);
		tempBuffer1.nz = - points[i].ny * sin(ax) + points[i].nz * cos(ax);
		
		//rotate around y axis
		tempBuffer2.nx = tempBuffer1.nx * cos(ay) - tempBuffer1.nz * sin(ay);
		tempBuffer2.ny = tempBuffer1.ny;
		tempBuffer2.nz = tempBuffer1.nx * sin(ay) + tempBuffer1.nz * cos(ay);

		//rotate around z axis
		transformed[i].nx = tempBuffer2.nx * cos(az) + tempBuffer2.ny * sin(az);
		transformed[i].ny =  - tempBuffer2.nx * sin(az) + tempBuffer2.ny * cos(az);
		transformed[i].nz = tempBuffer2.nz;
	}

}

Cube::Project(int CenterX, int CenterY)
{
	for (int i = 0; i < 8; i++)
	{
		transformed[i].sx = CenterX + VIEW_DISTANCE * transformed[i].x / (VIEW_DISTANCE - transformed[i].z);
		transformed[i].sy = CenterY + VIEW_DISTANCE * transformed[i].y / (VIEW_DISTANCE - transformed[i].z);
	}
}

Cube::Display(unsigned char type, long color)
{
	for (int i = 0; i < 6; i++)
	{
		faces[i].Display(type, color);
	}	
}

void Cube::InitNormals()
{
	Point3d * tp1 = new Point3d(), * tp2 = new Point3d();
	register int i;
	
	for (i = 0; i < 6; i++)
	{

		tp1->x = faces[i].p2->x - faces[i].p1->x;
		tp1->y = faces[i].p2->y - faces[i].p1->y;
		tp1->z = faces[i].p2->z - faces[i].p1->z;
		tp2->x = faces[i].p3->x - faces[i].p1->x;
		tp2->y = faces[i].p3->y - faces[i].p1->y;
		tp2->z = faces[i].p3->z - faces[i].p1->z;

		faces[i].normal->x = tp1->y * tp2->z - tp2->y * tp1->z;
		faces[i].normal->y = tp1->z * tp2->x - tp2->z * tp1->x;
		faces[i].normal->z = tp1->x * tp2->y - tp2->x * tp1->y;
		
		double length = sqrt(faces[i].normal->x * faces[i].normal->x +
							 faces[i].normal->y * faces[i].normal->y +
							 faces[i].normal->z * faces[i].normal->z);

		faces[i].normal->x =  faces[i].normal->x / length;
		faces[i].normal->y =  faces[i].normal->y / length;
		faces[i].normal->z =  faces[i].normal->z / length;

/*   hmm...things got messy with points[] & transormed[], as faces take their points from
	 transformed[], and transformed, when rotated - from points[], so let's have points
	 initialized here */

		points[i + 8].x = faces[i].normal->x;
		points[i + 8].y = faces[i].normal->y;
		points[i + 8].z = faces[i].normal->z;	
	}

		delete tp1;
		delete tp2; 	
}

void Cube::InitFakeNormals() //looong ang ugly....
{
	double length;

//init by averaging normals to faces through this vertex

	points[0].nx = float(faces[0].normal->x + 
				    faces[2].normal->x + 
				    faces[5].normal->x ) / 3; 
	points[0].ny = float(faces[0].normal->y + 
				    faces[2].normal->y + 
				    faces[5].normal->y ) / 3; 
	points[0].nz = float(faces[0].normal->z + 
				    faces[2].normal->z + 
				    faces[5].normal->z ) / 3; 

	points[1].nx = float(faces[0].normal->x + 
				    faces[3].normal->x + 
				    faces[5].normal->x ) / 3; 
	points[1].ny = float(faces[0].normal->y + 
				    faces[3].normal->y + 
				    faces[5].normal->y ) / 3; 
	points[1].nz = float(faces[0].normal->z + 
				    faces[3].normal->z + 
				    faces[5].normal->z ) / 3; 

	points[2].nx = float(faces[0].normal->x + 
				    faces[3].normal->x + 
				    faces[4].normal->x ) / 3; 
	points[2].ny = float(faces[0].normal->y + 
				    faces[3].normal->y + 
				    faces[4].normal->y ) / 3; 
	points[2].nz = float(faces[0].normal->z + 
				    faces[3].normal->z + 
				    faces[4].normal->z ) / 3; 

	points[3].nx = float(faces[0].normal->x + 
				    faces[2].normal->x + 
				    faces[4].normal->x ) / 3; 
	points[3].ny = float(faces[0].normal->y + 
				    faces[2].normal->y + 
				    faces[4].normal->y ) / 3; 
	points[3].nz = float(faces[0].normal->z + 
				    faces[2].normal->z + 
				    faces[4].normal->z ) / 3; 

	points[4].nx = float(faces[1].normal->x + 
				    faces[2].normal->x + 
				    faces[5].normal->x ) / 3; 
	points[4].ny = float(faces[1].normal->y + 
				    faces[2].normal->y + 
				    faces[5].normal->y ) / 3; 
	points[4].nz = float(faces[1].normal->z + 
				    faces[2].normal->z + 
				    faces[5].normal->z ) / 3; 

	points[5].nx = float(faces[1].normal->x + 
				    faces[3].normal->x + 
				    faces[5].normal->x ) / 3; 
	points[5].ny = float(faces[1].normal->y + 
				    faces[3].normal->y + 
				    faces[5].normal->y ) / 3; 
	points[5].nz = float(faces[1].normal->z + 
				    faces[3].normal->z + 
				    faces[5].normal->z ) / 3; 

	points[6].nx = float(faces[1].normal->x + 
				    faces[3].normal->x + 
				    faces[4].normal->x ) / 3; 
	points[6].ny = float(faces[1].normal->y + 
				    faces[3].normal->y + 
				    faces[4].normal->y ) / 3; 
	points[6].nz = float(faces[1].normal->z + 
				    faces[3].normal->z + 
				    faces[4].normal->z ) / 3; 

	points[7].nx = float(faces[1].normal->x + 
				    faces[2].normal->x + 
				    faces[4].normal->x ) / 3; 
	points[7].ny = float(faces[1].normal->y + 
				    faces[2].normal->y + 
				    faces[4].normal->y ) / 3; 
	points[7].nz = float(faces[1].normal->z + 
				    faces[2].normal->z + 
				    faces[4].normal->z ) / 3; 

//normalize

	for (int i = 0; i < 8; i++)
	{
		length = sqrt(points[i].nx *  points[i].nx +
					  points[i].ny *  points[i].ny +
					  points[i].nz *  points[i].nz);
		transformed[i].nx = points[i].nx = float(points[i].nx / length);
		transformed[i].ny = points[i].ny = float(points[i].ny / length);
		transformed[i].nz = points[i].nz = float(points[i].nz / length);
	}
}
